function [class] = postclassify(proc_data,channels,punc_data,output)
%This function takes data generated by classified and performs a permutated
%grouping, thus producing classes.
%Synatax:   [class] = postclassify(data,[1 2 4 7],punc_data,1); 
%Input:     proc_data = the data structure generated by classified
%           channels = the channels you want in this class.
%           punc_data = come full circle, the original data structure from
%                   punc_me_lite
%           output = save the files out, default = 0
%Output:    class = The structure contains fields: number, vertex, name  
%                   Number: is the number of occurance of this class in the
%                           dataset.
%                   Vertex_ori: the ori vertex. 
%                   Vertex_termi: the termini vertex.
%                   Channels: the channels included in this category, e.g.,
%                   [1 3 5]
%                   names: the names of those channels

if nargin==3
    output = 0;     %default no output
end

%pullout some useful info and parse the data a little
classes = proc_data(1).classes;
data = proc_data(1).data;
ch_ord = proc_data(1).ch_ord;
ori = proc_data(1).ori;
termi = proc_data(1).termi;
%remove ori and termi from the channels to look for if present
channels(channels==ori) = [];
channels(channels==termi) = [];

%now convert the channels in matrix index
[y,x] = find(repmat(ch_ord,size(channels,2),1)==repmat(channels',1,size(ch_ord,2)));
data_tmp = classes(:,x);        %pull out the subset

[y,x] = find(data_tmp==0);          %pull out the index for all that does not meet requirment
%pretty y up for output, not absolutely necessary
y = sortrows(y,1);                  %sort the index
y = collapse(y,1);                  %collapse the index so no repeats
%use y
data(y,:) = [];                     %delete the none qualifiying rows

%create output data structure
class(1).number = size(data,1);     %number of occurances in the dataset of this class.
class(1).vertex_ori = data(:,3:5);  %vertices of the origin for all the occurances
class(1).vertex_termi = data(:,8:10);   %vertices of the termini for all occurances
class(1).removed = y;                   %the removed vertices' index
class(1).channels = [ori termi channels];           %the channels included in this class.
class(1).names = punc_data(1).filenames(1,[ori termi channels]);    %the channel names.

%output
if output
    mkdir([channel_paths,'class'],cell2mat(class(1).names));
    ori_out = dataset(class(1).vertex_ori);               %to export as a XLS need to make the data a dataset.
    termi_out = dataset(class(1).vertex_termi);
    export(ori_out,'XLSfile',[[channel_paths,'class\',cell2mat(class(1).names),'\'],'vertex_ori.xls']);
    export(termi_out,'XLSfile',[[channel_paths,'class\',cell2mat(class(1).names),'\'],'vertex_termi.xls']);
    %export(ori_out,'File',[[channel_paths,'class\',cell2mat(class(1).names)],'\','vertex_ori.csv'],'delimiter',',')
    %export(termi_out,'File',[[channel_paths,'class\',cell2mat(class(1).names)],'\','vertex_termi.csv'],'delimiter',',')
end